/* eslint-disable max-len */
define([
    'underscore',
    'marionette',
    'App',
    'modules/new-appointment-wizard/wizard-section-view',
    'json!modules/community-care-request/new-appointment-request-question/facility-caretype-selection/community-care-facility-caretype.json',
],
function (_, Marionette, app, WizardSectionView, metadata) {
    'use strict';

    return WizardSectionView.extend({
        initialize: function (options) {
            var careTypeList = [];

            this._initializeSection(options, 'caretype-section', metadata, options.step);

            options.ccTypeOfCares.each(function(ccTypeOfCare) {
                careTypeList.push({
                    value: ccTypeOfCare.get('id'),
                    text: ccTypeOfCare.get('name'),
                    details: ccTypeOfCare.get('details'),
                    confirmation: ccTypeOfCare.get('confirmation'),
                });
            });
            this.collection.get('careType').set('values', _.sortBy(careTypeList, 'text'));
            this.collection.get('careTypeDetails').set('template', '<span class="static-text"><%= value %></span>');
            this.collection.get('careTypeConfirmation').set('template', '<span class="static-text"><%= value %></span>');

            this.initializeQuestionEventListeners();
        },
        modelEvents: {
            'change:careType': 'changeCareType',
            'change:careTypeContinue': 'changeCareTypeContinue',
        },
        hideElement: function(identifier) {
            this.$el.find(identifier).hide();
        },
        changeCareType: function() {
            // reset the continue option which hides caretype-confirmation
            var careType = _.find(this.collection.get('careType').get('values'), { value: this.model.get('careType') });

            this.model.set('careTypeContinue', '');
            if (careType) {
                this.model.set('careTypeName', careType.text);
                this.model.set('careTypeDetails', careType.details);

                // update the view now that the model has changed
                this.render();

                this.$el.find('.caretype-continue').show();
                this.hideElement('.caretype-confirmation');
            } else {
                // when: careType is falsely
                // then: the details and continue are hidden
                this.hideElement('.caretype-details');
                this.hideElement('.caretype-continue');
            }
        },
        changeCareTypeContinue: function() {
            var careType = _.find(this.collection.get('careType').get('values'), { value: this.model.get('careType') });

            if (this.model.get('careTypeContinue') === 'no') {
                this.model.set('careTypeConfirmation', careType.confirmation);

                this.render();
                this.$el.find('.caretype-confirmation').show();
            } else {
                this.hideElement('.caretype-confirmation');
            }
        },
        onRender: function () {
            // we hide all other questions if careType is not defined
            if (!this.model.get('careType')) {
                this.hideElement('.caretype-details');
                this.hideElement('.caretype-continue');
                this.hideElement('.caretype-confirmation');
            }
            if (this.model.get('careTypeContinue') === 'yes') {
                this.hideElement('.caretype-confirmation');
            }
        },
    });
});
